% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_kinship2pheno.R
\name{match.kinship2pheno}
\alias{match.kinship2pheno}
\title{Check any kinship matrix K against phenotypic data}
\usage{
match.kinship2pheno(
  K = NULL,
  pheno.data = NULL,
  indiv = NULL,
  clean = FALSE,
  ord = TRUE,
  mism = FALSE,
  message = TRUE
)
}
\arguments{
\item{K}{Input of a kinship matrix in full form (\eqn{n \times n}) (default = \code{NULL});}

\item{pheno.data}{A data fame with the phenotypic data to assess (for \code{n} individuals)
(default = \code{NULL}).}

\item{indiv}{The string for the column name for genotypes/individuals in the phenotypic data (default = \code{NULL}).}

\item{clean}{If \code{TRUE}, generates a new clean kinship matrix containing only the matched
phenotyped individuals (default = \code{FALSE}).}

\item{ord}{If \code{TRUE}, it will order the kinship matrix as in the phenotypic data, which is
recommended for some downstream genomic analyses (default = \code{TRUE}).}

\item{mism}{If \code{TRUE}, it generates data frames with matched and mismatched individual's names
from the kinship matrix and the phenotypic data (default = \code{FALSE}).}

\item{message}{If \code{TRUE} diagnostic messages are printed on screen (default = \code{TRUE}).}
}
\value{
A list with the following elements:
 \itemize{
\item{\code{mismatchesK}: a vector containing the names of the individuals from the provided kinship matrix
that \emph{mismatch} with the phenotypic data.}
\item{\code{matchesK}: a vector containing the names of the individuals from the provided kinship matrix
that \emph{match} with the phenotypic data.}
\item{\code{mismatchesP}: a vector containing the names of phenotyped individuals
that \emph{mismatch} with those from the kinship matrix.}
\item{\code{matchesP}: a vector containing the names of phenotyped individuals
that \emph{match} with those from the kinship matrix.}
\item{\code{Kclean}: a clean kinship matrix containing only the matched phenotyped individuals.}
}
}
\description{
Assesses a given kinship matrix against the provided phenotypic data to determine
if all genotypes are in the kinship matrix or not. It also reports which individuals
match or are missing from one set or another.
If requested, a reduced kinship matrix is generated that has only the matched individuals.
The input kinship matrix can be a pedigree-based relationship matrix \eqn{\boldsymbol{A}},
a genomic-based relationship matrix \eqn{\boldsymbol{G}}, or a hybrid
relationship matrix \eqn{\boldsymbol{H}}.
Individual names should be assigned to \code{rownames} and \code{colnames} of input matrix.
}
\examples{
\dontrun{
# Get G matrix.
G <- G.matrix(M = geno.pine655, method = "VanRaden", na.string = "-9", sparseform = FALSE)$G
dim(G)

# Match G and the phenotype.
check <-
 match.kinship2pheno(
  K = G, pheno.data = pheno.pine,
  indiv = "Genotype",
  clean = TRUE, mism = TRUE)
ls(check)
length(check$matchesK)
length(check$mismatchesK)
length(check$matchesP)
length(check$mismatchesP)
dim(check$Kclean)
}
}
