% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_sample_mvt.R
\name{step1_sample_mvt}
\alias{step1_sample_mvt}
\title{Sample the Multivariate t Distribution}
\usage{
step1_sample_mvt(
  data,
  y,
  .time,
  K = NULL,
  C = NULL,
  validation = NULL,
  draw,
  parms = NULL,
  reparameterisation = FALSE,
  zero_order = FALSE,
  ...
)
}
\arguments{
\item{data}{Dataframe containing accelerated stability data (required).}

\item{y}{Name of decreasing variable (e.g. concentration) contained within data
(required).}

\item{.time}{Time variable contained within data (required).}

\item{K}{Kelvin variable (numeric or column name) (optional).}

\item{C}{Celsius variable (numeric or column name) (optional).}

\item{validation}{Validation dummy variable (column name) (optional).}

\item{draw}{Number of samples to draw from mvt (required).}

\item{parms}{Starting values for the parameters as a list - k1, k2, k3, and c0 (optional).}

\item{reparameterisation}{Use alternative parameterisation of the one-step
model which aims to reduce correlation between k1 and k2.}

\item{zero_order}{Set kinetic order, k3, to zero (straight lines).}

\item{...}{Further arguments to passed to minpack.lm.}
}
\value{
A matrix containing parameter draws from the mvt distribution.
}
\description{
Take a selected number of samples from the multivariate t distribution (mvt).
}
\details{
Using the provided data the function creates a fit of the
Šesták–Berggren kinetic model and then draws a selected number of
samples from the mvt of the model parameters.
}
\examples{
#load antigenicity data.
data(antigenicity)

#Basic use of the step1_sample_mvt function with C column defined and 1000 draws.
sample1 <- step1_sample_mvt(data = antigenicity, y = "conc", .time = "time",
 C = "Celsius", draw = 1000)

#Basic use of the step1_sample_mvt function with K column defined and 50000 draws
sample2 <- step1_sample_mvt(data = antigenicity, y = "conc", .time = "time",
 K = "K", draw = 50000)

#reparameterisation is TRUE and 10000 draws.
sample3 <- step1_sample_mvt(data = antigenicity, y = "conc", .time = "time",
C = "Celsius", reparameterisation = TRUE, draw = 10000)

}
