% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BonferroniTest.R
\name{BonferroniTest}
\alias{BonferroniTest}
\title{Bonferroni-Corrected Pairwise t-Tests v2.0}
\usage{
BonferroniTest(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An \code{aov} or \code{lm} object (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default 0.05).}
}
\value{
An object of class \code{"bonferroni"} and \code{"comparaciones"} containing:
\itemize{
  \item \code{Resultados}: a data.frame with columns \code{Comparacion}, \code{Diferencia}, \code{SE}, \code{t_value},
        \code{p_value} (unadjusted), \code{p_ajustada} (Bonferroni), \code{Valor_Critico} (critical difference), and \code{Significancia}.
  \item \code{Promedios}: a named vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: group names ordered from highest to lowest mean.
  \item \code{Metodo}: "Bonferroni-adjusted t-test".
  \item \code{Termino}: the term being compared (e.g., "A", "B", or "A:B").
  \item \code{MSerror}, \code{df_error}, \code{N}: useful for plots with error bars.
}
}
\description{
Performs pairwise t-tests with Bonferroni adjustment for multiple comparisons.
This method controls the family-wise error rate by dividing the alpha level
by the number of comparisons.
}
\details{
Advantages:
- Very simple and easy to implement.
- Strong control of Type I error.
- Applicable to any set of independent comparisons.

Disadvantages:
- Highly conservative, especially with many groups.
- Can lead to low statistical power (increased Type II error).
- Does not adjust test statistics, only p-values.
}
\examples{
#DCA
data(d_e, package = "Analitica")
mod1 <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
summary(mod1)
resultado <- BonferroniTest(mod1)
summary(resultado)

DBA: y ~ tratamiento + bloque
mod2 <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
res <- BonferroniTest(mod2, comparar = "as.factor(labor)")
summary(res); plot(res)

# DFactorial: y ~ A * B
mod2 <- aov(Sueldo_actual ~ as.factor(labor) * Sexo, data = d_e)
resAB <- BonferroniTest(mod2, comparar = c("as.factor(labor)","Sexo"))  # compara celdas A:B
summary(resAB, n = Inf); plot(resAB, horizontal = TRUE)

}
\references{
Dunn, O. J. (1964). Multiple Comparisons Using Rank Sums. \emph{Technometrics}, 6(3), 241–252. \doi{10.1080/00401706.1964.10490181}

Wilcoxon, F. (1945). Individual Comparisons by Ranking Methods. \emph{Biometrics Bulletin}, 1(6), 80–83. \doi{10.2307/3001968}
}
