% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_usd_exchange_rates.R
\name{get_usd_exchange_rates}
\alias{get_usd_exchange_rates}
\title{Get USD Exchange Rates from Argentina's Currency Markets}
\usage{
get_usd_exchange_rates()
}
\value{
A data frame (tibble) with the following columns:
\itemize{
  \item \code{casa}: Name of the exchange house (e.g., Blue, Oficial, Mayorista).
  \item \code{compra}: Buying rate (numeric).
  \item \code{venta}: Selling rate (numeric).
  \item \code{fecha}: Date of the rate (Date format).
}
}
\description{
This function retrieves the latest exchange rates of the US dollar (USD) from multiple
currency exchange houses in Argentina, using the public API
`https://api.argentinadatos.com/v1/cotizaciones/dolares`. The results are sorted in
descending order by date (most recent first).
}
\details{
The function connects to the ArgentinaDatos API to obtain current USD exchange rates. It arranges
the results in descending order by date, making recent data easier to access.
}
\note{
Requires an internet connection. Results may vary depending on API availability.
}
\examples{
\dontrun{
# Get latest USD exchange rates
rates <- get_usd_exchange_rates()
head(rates)  # Shows the most recent ones first

# Filter for the year 2025
rates_2025 <- dplyr::filter(rates, lubridate::year(fecha) == 2025)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{arrange}}
}
