% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hill}
\alias{hill}
\title{Hill numbers.}
\usage{
hill(comm, q = 0, raref = 0, runs = 100)
}
\arguments{
\item{comm}{A sites x species matrix, with abundance data.}

\item{q}{Hill number order: q(0) = species richness, q(1) ~ Shannon diversity, q(2) ~ Simpson diversity, and so on...}

\item{raref}{An integer specifying the number of individuals for rarefaction (individual based).
If raref < 1 no rarefaction is made.
If raref = 1 rarefaction is made by the minimum abundance among all sites.
If raref > 1 rarefaction is made by the abundance indicated.
If not specified, default is 0.}

\item{runs}{Number of resampling runs for rarefaction. If not specified, default is 100.}
}
\value{
A matrix of sites x diversity values (either "Hill q" OR "Mean, Median, Min, LowerCL, UpperCL and Max").
}
\description{
Hill numbers with possible rarefaction, multiple sites simultaneously.
}
\details{
Hill numbers are based on the number of equally abundant species  that would match the current diversity.
Depending on the single parameter they give more or less weight to rare species (Jost 2002).
}
\examples{
comm <- matrix(c(0,0,1,1,0,0,100,1,0,0), nrow = 2, ncol = 5, byrow = TRUE)
hill(comm)
hill(comm, q = 1)
hill(comm, q = 4, 1)
}
\references{
Hill, M.O. (1973). Diversity and evenness: a unifying notation and its consequences. Ecology, 54: 427-432.
}
