% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_bls_dataset.R
\name{load_bls_dataset}
\alias{load_bls_dataset}
\title{Generic BLS Dataset Download}
\usage{
load_bls_dataset(
  database_code,
  return_full = FALSE,
  simplify_table = TRUE,
  suppress_warnings = FALSE
)
}
\arguments{
\item{database_code}{This is the two digit character identifier for the desired database.
Some Valid options are:
\itemize{
  \item "ce" - National Current Employment Statistics Data
  \item "sm" - State and Metro area Current Employment Statistics Data
  \item "mp" - Major Sector Total Factor Productivity
  \item "ci" - Employment Cost Index
  \item "eb" - Employee Benefits Survey
}}

\item{return_full}{This argument defaults to FALSE. If set to TRUE it will return
a list of the elements of data retrieved from the BLS separating the data, series, and
mapping values downloaded.}

\item{simplify_table}{This parameter defaults to TRUE. When TRUE it will remove all
columns from the date with "_code" in the column name, as well as a series of internal
identifiers which provide general information about the series but which are not needed for
performing time series analysis. This parameter also converts the column "value" to numeric
and generates a date column from the year and period columns in the data.}

\item{suppress_warnings}{Logical. If TRUE, suppress individual download warnings during processing.}
}
\value{
This function will return either a bls_data_collection object (if return_full is FALSE or not provided)
 or a named list of the returned data including the bls_data_collection object.
}
\description{
This function generalizes a method to download all BLS data for a given time series database.
These files are accessed from https://download.bls.gov/pub/time.series/ and several datasets
are available. A summary of an identified database can be generated using the `bls_overiew()`
function. When multiple potential data files exist (common in large data sets), the function
will prompt for an input of which file to use.
}
\examples{
\dontrun{
# Download Employer Cost Index Data
cost_index <- load_bls_dataset("ci")

# Download separated data, series, and mapping columns
benefits <- load_bls_dataset("eb", return_full = TRUE)

# Download data without removing excess columns and value conversions
productivity <- load_bls_dataset("mp", simplify_table = FALSE)

# Check for download issues
if (has_bls_issues(cost_index)) {
  print_bls_warnings(cost_index, detailed = TRUE)
}
}
}
