% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.euclidean_linker_cpp}
\alias{.euclidean_linker_cpp}
\title{Return the group number for each localization.}
\usage{
.euclidean_linker_cpp(input, critDist, use_prog_bar = TRUE)
}
\arguments{
\item{input}{A numeric matrix where each row is a localization and each
column is a spatial axis.}

\item{critDist}{The critical distance for which localizations nearer than
this distance are deemed part of the same group.}

\item{use_prog_bar}{A logical indicating whether a progress bar should be
used. This must be set to false when running in parallel.}
}
\description{
Group PALM/iPALM localizations based on their physical separation distance

PALM/iPALM data results in a list of spatial coordinates for fluorophore
localizations. This function groups nearby localizations if they are within
the provided critical distance from each other.
}
\examples{
# Function call
\dontrun{.euclidean_linker_cpp(inputMatrix, critDist)}

}
\author{
Zach Colburn
}
