% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3generics_clvtime.R
\name{print.clv.time}
\alias{print.clv.time}
\alias{summary.clv.time}
\title{Summarizing a CLV time object}
\usage{
\method{print}{clv.time}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{clv.time}(object, ...)
}
\arguments{
\item{x}{An object of class \code{"summary.clv.time"}, usually, a result of a call to \code{summary.clv.time}.}

\item{digits}{The number of significant digits to use when printing.}

\item{...}{Ignored.}

\item{object}{A CLV time object}
}
\value{
This function computes and returns summary statistics of the
time related information stored in \code{object}. It returns a list of
class \code{summary.clv.time} that contains the elements:
\item{time.unit}{What time unit defines a single period.}
\item{estimation.period.in.tu}{Length of estimation period in time units.}
\item{has.holdout}{Whether the object has a holdout data sample.}
\item{holdout.period.in.tu}{Length of holdout period in time units, if any.}
}
\description{
Summary method for CLV time objects that provides information about the start and end date of
the estimation and possible holdout sample.
}
\seealso{
\code{\link[CLVTools:summary.clv.data]{summary.clv.data}} for how to summarize a clv data object
}
\keyword{internal}
