% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmtf_opt.R
\name{acmtf_opt}
\alias{acmtf_opt}
\title{Advanced coupled matrix and tensor factorizations}
\usage{
acmtf_opt(
  Z,
  numComponents,
  initialization = "random",
  alpha = 1,
  beta = rep(0.001, length(Z$object)),
  epsilon = 1e-08,
  method = "CG",
  cg_update = "HS",
  line_search = "MT",
  max_iter = 10000,
  max_fn = 10000,
  abs_tol = 1e-10,
  rel_tol = 1e-10,
  grad_tol = 1e-10,
  nstart = 1,
  numCores = 1,
  sortComponents = TRUE,
  allOutput = FALSE
)
}
\arguments{
\item{Z}{Combined dataset and mode object as produced by \code{\link[=setupCMTFdata]{setupCMTFdata()}}.}

\item{numComponents}{Number of components}

\item{initialization}{Initialization, either "random" (default) or "nvec" for numComponents components of the concatenated data using svd.}

\item{alpha}{Scalar penalizing the components to be norm 1 (default 1).}

\item{beta}{Vector of penalty values for each dataset, penalizing the lambda terms (default 1e-3).}

\item{epsilon}{Scalar value to make it possible to compute the partial derivatives of lambda (default 1e-8).}

\item{method}{Optimization method to use (default = "CG", the conjugate gradient). See \code{\link[mize:mize]{mize::mize()}} for other options.}

\item{cg_update}{Update method for the conjugate gradient algorithm, see \code{\link[mize:mize]{mize::mize()}} for the options (default="HS", Hestenes-Steifel).}

\item{line_search}{Line search algorithm to use, see \code{\link[mize:mize]{mize::mize()}} for the options (default="MT", More-Thuente).}

\item{max_iter}{Maximum number of iterations.}

\item{max_fn}{Maximum number of function evaluations.}

\item{abs_tol}{Function tolerance criterion for convergence.}

\item{rel_tol}{Relative function tolerance criterion for convergence.}

\item{grad_tol}{Absolute tolerence for the l2-norm of the gradient vector.}

\item{nstart}{Number of models to produce (default 1). If set higher than one, the package will return the best fitted model.}

\item{numCores}{Number of cores to use (default 1). If set higher than one, the package will attempt to run in parallel.}

\item{sortComponents}{Sort the components in the output by descending order of variation explained.}

\item{allOutput}{Return all created models. Ignored if nstart=1.}
}
\value{
List object, similar to \code{\link[mize:mize]{mize::mize()}} output. Includes a Fac object of the model, which is a list of components per mode. Also includes an init object giving the initialized input vectors.
}
\description{
Advanced coupled matrix and tensor factorizations
}
\examples{
A = array(rnorm(108*2), c(108, 2))
B = array(rnorm(100*2), c(100, 2))
C = array(rnorm(10*2), c(10, 2))
D = array(rnorm(100*2), c(100,2))
E = array(rnorm(10*2), c(10,2))

df1 = reinflateTensor(A, B, C)
df2 = reinflateTensor(A, D, E)
datasets = list(df1, df2)
modes = list(c(1,2,3), c(1,4,5))
Z = setupCMTFdata(datasets, modes, normalize=FALSE)

# specific setting to reduce runtime for CRAN
model = acmtf_opt(Z, 1, rel_tol=1e-5, abs_tol=1e-5)
}
