% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cras_write.R
\name{cras_write}
\alias{cras_write}
\title{Write CRediT author statement}
\usage{
cras_write(
  cras_table,
  file,
  drop_authors = TRUE,
  overwrite = FALSE,
  markdown = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{cras_table}{A data.frame created using \code{create_template()}}

\item{file}{The text file to be created. If not provided (default), the statement is
returned as a string instead of written to a file.}

\item{drop_authors}{If TRUE (default) the authors without contributions are
removed from the statement. If FALSE, they are kept without contributions
assigned.}

\item{overwrite}{If TRUE, the file is overwritten. Otherwise, a error is
triggered.}

\item{markdown}{If TRUE (default), the authors are surrounded by ** to make
them bold in markdown.}

\item{quiet}{If TRUE and \code{drop_authors} is also TRUE, authors without
contributions are silently dropped out.
If FALSE, a warning is triggered in case any authors is dropped out.}
}
\value{
A text file with the CRediT authors statement or, if file is NULL
(default), a character vector of length 1 with the statement that can be
used in a Rmarkdown or quarto document using inline code:
\code{`r cras_write(cras_table, markdown = TRUE)`}
}
\description{
The function transforms the information in the template
(from \code{template_create}) to a raw string following the CRediT authors
statement format of "author1: contributions author2: contributions ..."
}
\examples{
# Generate a template and populate it (randomwly for this example)
cras_table <- template_create(authors = c("Josep Maria", "Jane Doe"))
cras_table[,2:ncol(cras_table)] <- sample(0:1, (ncol(cras_table)-1)*2,
                                          replace = TRUE)

# Create a temporary file just for this example
file <- tempfile()

# Write to the file
cras_write(cras_table, file, markdown = TRUE)

# Check the content of the file
readLines(file)
}
