% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSeQTL.R
\name{CSeQTL_full_analysis}
\alias{CSeQTL_full_analysis}
\title{CSeQTL_full_analysis}
\usage{
CSeQTL_full_analysis(
  TREC,
  hap2,
  ASREC,
  PHASE,
  SNP,
  RHO,
  XX,
  log_lib_size,
  vec_MARG = c(TRUE, FALSE),
  vec_TRIM = c(TRUE, FALSE),
  vec_PERM = c(TRUE, FALSE),
  thres_TRIM = 10,
  ncores = 1,
  show = TRUE
)
}
\arguments{
\item{TREC}{An integer vector of total read counts.}

\item{hap2}{An integer vector of second haplotype counts}

\item{ASREC}{An integer vector of total haplotype counts}

\item{PHASE}{An integer vector of 0s and 1s denoting if a subject 
has available haplotype counts.}

\item{SNP}{An integer vector of phased genotypes coded 0 (AA),
1 (AB), 2 (BA), 3 (BB), and 5 (NA).}

\item{RHO}{A numeric matrix of cell type proportions. Rows 
correspond to subjects and columns correspond to cell types.}

\item{XX}{A numeric design matrix of baseline covariates 
including the intercept in the first column and centered 
continuous covariates.}

\item{log_lib_size}{A positive numeric vector of log transformed
library sizes per subject.}

\item{vec_MARG}{A boolean vector for marginal and/or cell type-specific
analyses to be run. By default, both sets of analyses are run.}

\item{vec_TRIM}{A boolean vector for whether or not analyses with 
trimmed outcomes are included. By default, both sets of analyses are run.}

\item{vec_PERM}{A boolean vector for whether or not permuted SNP analyses
are included. By default, both sets of analyses are run.}

\item{thres_TRIM}{A positive numeric value to perform subject outcome trimming.
Subjects with standardized Cooks' Distances greater than the threshold are trimmed.}

\item{ncores}{A positive integer specifying the number of threads available
to decrease computational runtime.}

\item{show}{A boolean value to display verbose output and plot intermediate 
simulated results.}
}
\value{
A R list containing multiple objects. \code{res} is a R dataframe
containing the model fitted, marginal model indicator, TRIM indicator, 
permutation indicator, cell types, utilized allele-specific reads indicator,
A and B allele-specific expression, eta/eqtl fold change estimate, p-value.
\code{out} contains lists of detailed estimates per model fit.
}
\description{
Performs marginal and cell type-specific eQTL analysis
with both CSeQTL and OLS models for simulation and comparative purposes.
}
