% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{cardiovascular_list}
\alias{cardiovascular_list}
\title{Statin Dose Comparison Trials for CVD}
\format{
A list with 4 components:
\describe{
\item{Study}{Study identifiers (integer vector of length 34)}
\item{Treat}{Treatment assignments (numeric vector: 1=low dose, 2=high dose, 3=placebo)}
\item{Outcomes}{Outcome matrix with 34 rows and 3 columns:
\describe{
\item{Alive}{Number of patients alive (numeric)}
\item{FnCVD}{Number with non-fatal CVD events (numeric)}
\item{FCVD}{Number with fatal CVD events (numeric)}
}
}
\item{N}{Sample sizes (numeric vector of length 34)}
}
}
\source{
Data taken from the bnma package version 1.6.0
}
\usage{
data(cardiovascular_list)
}
\description{
This dataset, cardiovascular_list, is a list containing data from 34 clinical trials
comparing low dose (1), high dose (2), and placebo (3) statins for cardiovascular disease
prevention. The dataset includes study identifiers, treatment assignments, and outcome counts.
}
\details{
The dataset name has been kept as 'cardiovascular_list' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The original content has not been modified in any way.
}
