% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicRun.R
\name{LogisticRun}
\alias{LogisticRun}
\title{Fully runs a logistic regression model, returning the model and results}
\usage{
LogisticRun(
  model,
  df,
  a_n = list(c(0)),
  keep_constant = c(0),
  control = list(),
  gradient_control = list(),
  link = "odds",
  single = FALSE,
  observed_info = FALSE,
  cons_mat = as.matrix(c(0)),
  cons_vec = c(0),
  norm = "null",
  ...
)
}
\arguments{
\item{model}{either a formula written for the get_form function, or the model result from the get_form function.}

\item{df}{a data.table containing the columns of interest}

\item{a_n}{list of initial parameter values, used to determine the number of parameters. May be either a list of vectors or a single vector.}

\item{keep_constant}{binary values to denote which parameters to change}

\item{control}{list of parameters controlling the convergence, see the Control_Options vignette for details}

\item{gradient_control}{a list of control options for the gradient descent algorithm. If any value is given, a gradient descent algorithm is used instead of Newton-Raphson. See the Control_Options vignette for details}

\item{link}{Used in logistic regression, the linking function relating the input model and event probability. Current options are "odds", "ident", and "loglink" for the odds ratio, identity, and complimentary loglink options.}

\item{single}{a boolean to denote that only the log-likelihood should be calculated and returned, no derivatives or iterations}

\item{observed_info}{a boolean to denote that the observed information matrix should be used to calculate the standard error for parameters, not the expected information matrix}

\item{cons_mat}{Matrix containing coefficients for a system of linear constraints, formatted as matrix}

\item{cons_vec}{Vector containing constants for a system of linear constraints, formatted as vector}

\item{norm}{methods used to normalize the covariates. Default is 'null' for no normalization. Other options include 'max' to normalize by the absolute maximum and 'mean' to normalize by the mean}

\item{...}{can include the named entries for the control list parameter}
}
\value{
returns a class fully describing the model and the regression results
}
\description{
\code{LogisticRun} uses a formula, data.table, and list of controls to prepare and
run a Colossus logistic regression function
}
\examples{
library(data.table)
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "Starting_Age" = c(18, 20, 18, 19, 21, 20, 18),
  "Ending_Age" = c(30, 45, 57, 47, 36, 60, 55),
  "Cancer_Status" = c(0, 0, 1, 0, 1, 0, 0),
  "a" = c(0, 1, 1, 0, 1, 0, 1),
  "b" = c(1, 1.1, 2.1, 2, 0.1, 1, 0.2),
  "c" = c(10, 11, 10, 11, 12, 9, 11),
  "d" = c(0, 0, 0, 1, 1, 1, 1),
  "e" = c(0, 0, 1, 0, 0, 0, 1)
)
control <- list(
  "ncores" = 2, "lr" = 0.75, "maxiters" = c(1, 1),
  "halfmax" = 1
)
formula <- logit(Cancer_Status) ~
  loglinear(a, b, c, 0) + plinear(d, 0) + multiplicative()
res <- LogisticRun(formula, df, a_n = c(1.1, -0.1, 0.2, 0.5), control = control)
}
\seealso{
Other Logistic Wrapper Functions: 
\code{\link{RunLogisticRegression_Omnibus}()}
}
\concept{Logistic Wrapper Functions}
