% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LADVAR.R
\name{LADVAR}
\alias{LADVAR}
\title{Least absolute deviation vector autoregression}
\usage{
LADVAR(x, configuration = list(nlag = 1))
}
\arguments{
\item{x}{zoo data matrix}

\item{configuration}{model configuration}

\item{nlag}{Lag length}
}
\value{
Estimate LAD VAR model
}
\description{
Estimation of a LAD VAR using equation-by-equation LAD regressions.
}
\examples{
data("dy2012")
fit = LADVAR(dy2012, configuration=list(nlag=1))
}
\author{
David Gabauer
}
