% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-methods.R
\docType{class}
\name{DeponsRaster-class}
\alias{DeponsRaster-class}
\title{DeponsRaster-class}
\description{
Stores objects containing raster landscapes used as input in
DEPONS simulations.
}
\section{Slots}{

\describe{
\item{\code{type}}{Character. Identifies the kind of data stored in the raster; should
be 'food', 'patches', bathymetry', 'dtc', 'salinity', 'blocks' or 'NA'.}

\item{\code{landscape}}{Character  Identifier for the landscape used in the DEPONS
simulations. The landscapes 'DanTysk', 'Gemini', 'Kattegat', 'North Sea',
'Homogeneous', and 'User defined' are distributed with the DEPONS model.}

\item{\code{crs}}{Object of class "CRS", i.e. the coordinate reference system. This
is provided as a proj4string text string.}

\item{\code{header}}{Data frame with data on number of columns and rows in the
input raster, the coordinates of the lower left corner, the size of each
grid cell and the integer value used to represent missing data.}

\item{\code{ext}}{Data frame with the extent of the landscape.}

\item{\code{data}}{The actual data values for each of the grid cells.}
}}

\note{
DeponsRaster-objects are typically read in from ascii raster files that
have been used for DEPONS simulations.
}
\examples{
a.deponsraster <- new("DeponsRaster")
a.deponsraster
}
\seealso{
\code{\link[DEPONS2R]{plot.DeponsRaster}}, \code{\link[DEPONS2R]{read.DeponsRaster}} and
\code{\link[DEPONS2R]{make.blocksraster}}. \code{\link{bathymetry}} is an example
of a \code{DeponsRaster}-object.
}
