% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-methods.R
\name{as.raster}
\alias{as.raster}
\alias{as.raster,DeponsRaster-method}
\title{Convert a DeponsRaster into a RasterLayer}
\usage{
\S4method{as.raster}{DeponsRaster}(x)
}
\arguments{
\item{x}{A \code{DeponsRaster}}
}
\value{
A \code{RasterLayer}
}
\description{
Converts a \code{DeponsRaster} into a \code{\link[raster:Raster-class]{RasterLayer}} for easier manipulation with common R tools.
}
\details{
Maintains cell size / resolution, CRS (if defined) and value of NA cells.
}
\examples{
data(bathymetry)
y <- as.raster(bathymetry)
}
\seealso{
\code{\link{as.DeponsRaster}} for converting a RasterLayer into a DeponsRaster
}
