% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_5FSD.R
\name{compute.fsd}
\alias{compute.fsd}
\title{Fraction of Standard Deviation (FSD)}
\usage{
compute.fsd(Y, X, verbose = F)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}

\item{verbose}{if TRUE, print advice about the quality of the model}
}
\description{
Estimates the Fraction of Standard Deviation (FSD) of two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the value of FSD of two vectors corresponding to univariate signals.
Values of FSD closer to zero indicate a better performance method for the imputation task.
Both vectors Y and X must be of equal length, on the contrary an error will be displayed.
In both input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1] ; Y <- dataDTWBI[, 2]
compute.fsd(Y,X)
compute.fsd(Y,X, verbose = TRUE)

# By definition, if true and imputed values are equal and constant,
# FSD = 0.
X <- rep(runif(1), 10)
Y <- X
compute.fsd(Y,X)

# However, if true and imputed values are constant but different,
# FSD is not calculable. An error is displayed.
\dontrun{
X <- rep(runif(1), 10);Y <- rep(runif(1), 10)
compute.fsd(Y,X)}
}
\author{
Camille Dezecache, Hong T. T. Phan, Emilie Poisson-Caillault
}
