% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_temporal.R
\name{plot_temporal}
\alias{plot_temporal}
\title{Generate temporal probability density plots}
\usage{
plot_temporal(relative_values, D)
}
\arguments{
\item{relative_values}{A list generated by \code{\link[=get_relative_values]{get_relative_values()}}.}

\item{D}{A single threshold value.}
}
\value{
A list of ggplots, one for each policy alternative.
}
\description{
The probability density of the peak (or lowest if the
threshold is a minimum) projected outcome across simulation runs is
plotted in the center of the graph for a given policy alternative.
Above and below, the probability density of the outcome at specified time
points relative to the time of the peak (or lowest) project outcome
is plotted to visually illustrate how uncertainty, and therefore risk,
changes over time. The decision threshold is shown directly on the plot as
a vertical line to provide a clear reference point for interpreting the
outputs.
}
\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
D <- 750
t_s <- 30
t_ss <- 10

peak_values_list <- get_max_min_values(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt_max = TRUE
)

peak_temporal_list <- get_relative_values(
  psa_data,
  peak_values_list,
  t_s = t_s,
  t_ss = t_ss
)

peak_temporal_plots <- plot_temporal(
  peak_temporal_list,
  D
)
}
