% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extricate.R
\name{extricate}
\alias{extricate}
\title{Extricate a signal: an EEMD algorithm}
\usage{
extricate(
  xy,
  dt,
  nimf,
  ini = NULL,
  repl = 1,
  comb = 100,
  mirror_noise = TRUE,
  factor_noise = 3,
  unit_noise = "1stdiff",
  sifting = 1,
  output_sifting = FALSE,
  remove = "lin.trend",
  bind = FALSE,
  speak = FALSE,
  plot_process = FALSE,
  pdf = TRUE,
  name = "extricate",
  ext = ".pdf",
  dir = tempdir(),
  width = 10,
  height = 20,
  track = TRUE,
  openfile = TRUE
)
}
\arguments{
\item{xy}{signal, maybe linearly interpolated to have regular sampling
interval}

\item{dt}{depth/time}

\item{nimf}{number of modes/components/intrinsic mode functions to decompose
the signal into}

\item{ini}{an optional vector of length n of the eventual initial Intrinsic
Mode Function xy would be a demodulation of, if it is a demodulation. In that
case the mode indexes will start at 2.}

\item{repl}{the amount of decompositions to output}

\item{comb}{the amount of decompositions each output decomposition will be a
combination of. Has to be a multiple of 2 (even and odd extension stacks
have to be combined in any case)}

\item{mirror_noise}{whether to generate a mirrored noise signal (for even and
odd extension) that will cancel perfectly when combining the decompositions}

\item{factor_noise}{a factor for the amplitude of white noise (finite
amplitude obtained via \code{\link{runif}}). By default it will be
multiplied with the mean of the lagged-one difference to define the noise
amplitude}

\item{unit_noise}{whether to multiply factor_noise by the mean of the
lagged-one difference (unit_noise = "1stdiff") or not (unit_noise =
"native")}

\item{sifting}{amount of iterations of the sifting process}

\item{output_sifting}{whether to output each sifting}

\item{remove}{whether to remove the linear trend (remove = "lin.trend") or
the mean (remove = "mean") prior to decomposition. The removed part will be
added back after the decomposition. If remove is anything else, nothing will
be removed, which can be problematic for the even and odd extension scheme
used.}

\item{bind}{whether to bind the removed linear trend or mean to the last
component (T), or to add it as another component (F)}

\item{speak}{whether to print a sentence at each sifting: it gives the stack
(even or odd), the mode number and sifting number}

\item{plot_process}{whether to have a plot of the entire sifting process.
This slows down the algorithm, use with low 'repl' and 'comb' values for
visualisation purposes}

\item{pdf}{whether the plot be directly set as a pdf file}

\item{name, ext, dir, width, height, track, openfile}{arguments to provide to
pdfDisplay if plot_process and pdf are TRUE}
}
\value{
a list made of $xy (original signal), $dt (depth/time), $m (a matrix
of the decomposition), $repl (the replicate id of each point) and
$mode (the mode id of each point). If output_sifting is TRUE, additional
$even_sifting and $odd_sifting data.tables are provided, giving the
condensed siftings for the even and odd extensions.
}
\description{
Performes EEMD
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5) + t * 0.01

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7, repl = 1, comb = 40, factor_noise = 10,
                 sifting = 10, speak = TRUE, output_sifting = TRUE)

integrity(xy, dec)

parsimony(dec)

plot_emd(dec, select = c(4, 6), pdf = FALSE)
\dontrun{
plot_emd(dec, li = list(v = 0), dir = tempdir())}

}
