% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pile.up.R
\name{pile.up}
\alias{pile.up}
\title{Repeat and stack a signal in central and line symmetry}
\usage{
pile.up(xy, dt, n, warn = TRUE)
}
\arguments{
\item{xy}{the signal}

\item{dt}{the depth/time positions of each xy}

\item{n}{the number of replicates you want. It has to be a multiple of two,
as you will generate two stacks: the even and the odd one.}

\item{warn}{whether you want to be annoyed}
}
\value{
a dataframe of the original dt (odt), the stack-modified dt (ndt),
the inversion factor to change the even stack into the odd one and
vice-versa (invert), the even xy stack (even) and the odd one (odd)
}
\description{
Repeats and stacks a signal duplicated in central (even) and
line (odd) symmetry to apply Ensemble Empirical Mode Decomposition (EEMD) on
one single vector following the simple boundary rule of Zeng and He (2004).
This allows to avoid the iterations that are typical of EEMD. A complete
set of signal is added by default at the upper and lower part of the stack,
to be removed in the end process.
}
\examples{
set.seed(42)

n <- 200
t <- seq_len(n)

p1 <- 25
p2 <- 75

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)
inter_dt[20] <- 20

dt <- cumsum(inter_dt)

opar <- par()$mfrow
par(mfrow = c(1,1))

res <- pile.up(xy, dt, 4)

par(mfrow = c(2,1))
plot(res$ndt, res$even, type = "l", col = "blue")
plot(res$ndt, res$odd,  type = "l", col = "red")

par(mfrow = c(opar))

}
