/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.rosuda.JGR.JGRObjectManager;
import org.rosuda.JGR.robjects.RModel;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.TableSorter;

public class ModelBrowserTable
extends JTable
implements MouseListener,
DragGestureListener,
DragSourceListener {
    private static final long serialVersionUID = -7841580144147512452L;
    private Vector models;
    private Vector fmodels;
    private TableSorter sorter;
    private JGRObjectManager objmgr;
    private DragSource dragSource;
    public FilterPanel filter;
    private final String[] colnames = new String[]{"Name", "Data", "Type", "family", "df", "r.squared", "aic", "deviance"};

    public ModelBrowserTable(JGRObjectManager jGRObjectManager, Vector vector) {
        this.models = vector;
        this.fmodels = new Vector(this.models);
        this.objmgr = jGRObjectManager;
        this.setColumnModel(new ModelTableColumnModel());
        this.sorter = new TableSorter(new ModelTableModel());
        this.setShowGrid(true);
        this.setModel(this.sorter);
        this.setAutoResizeMode(1);
        FontTracker.current.add(this);
        this.setRowHeight((int)((double)JGRPrefs.FontSize * 1.5));
        this.getTableHeader().setReorderingAllowed(false);
        this.sorter.setTableHeader(this.getTableHeader());
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        this.filter = new FilterPanel(this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.addMouseListener(this);
    }

    public void refresh() {
        int n;
        int[] nArray = new int[this.sorter.getColumnCount()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.sorter.getSortingStatus(n);
        }
        this.sorter = new TableSorter(new ModelTableModel());
        this.sorter.setTableHeader(this.getTableHeader());
        for (n = 0; n < nArray.length; ++n) {
            this.sorter.setSortingStatus(n, nArray[n]);
        }
        this.setModel(this.sorter);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
        if (mouseEvent.isAltDown()) {
            this.objmgr.setWorking(true);
            RModel rModel = (RModel)this.fmodels.elementAt(this.sorter.modelIndex(this.rowAtPoint(mouseEvent.getPoint())));
            if (rModel == null || rModel.getToolTip().trim().length() == 0) {
                return null;
            }
            String string = rModel.getToolTip();
            if (string != null) {
                this.objmgr.setWorking(false);
                return string;
            }
            return null;
        }
        this.objmgr.setWorking(false);
        return null;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        RModel rModel = (RModel)this.fmodels.elementAt(this.sorter.modelIndex(this.rowAtPoint(dragGestureEvent.getDragOrigin())));
        if (rModel == null || rModel.getCall().trim().length() == 0) {
            return;
        }
        StringSelection stringSelection = new StringSelection(rModel.getName() + " <- " + rModel.getTypeName() + "(" + rModel.getCall() + (rModel.getFamily() != null ? ",family=" + rModel.getFamily() : "") + (rModel.getData() != null ? ",data=" + rModel.getData() : "") + ")");
        this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, stringSelection, this);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
        if (mouseEvent.isPopupTrigger()) {
            this.objmgr.setWorking(true);
            JToolTip jToolTip = new JToolTip();
            RModel rModel = (RModel)this.fmodels.elementAt(this.sorter.modelIndex(this.rowAtPoint(mouseEvent.getPoint())));
            if (rModel == null || rModel.getToolTip().trim().length() == 0) {
                return;
            }
            String string = rModel.getToolTip();
            if (string == null) {
                this.objmgr.setWorking(false);
                return;
            }
            jToolTip.setTipText(rModel.getToolTip());
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this);
            this.objmgr.summary = PopupFactory.getSharedInstance().getPopup(this, jToolTip, point.x + 20, point.y + 25);
            this.objmgr.summary.show();
            this.objmgr.setWorking(false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.objmgr.setWorking(true);
            JToolTip jToolTip = new JToolTip();
            RModel rModel = (RModel)this.fmodels.elementAt(this.sorter.modelIndex(this.rowAtPoint(mouseEvent.getPoint())));
            if (rModel == null || rModel.getToolTip().trim().length() == 0) {
                return;
            }
            String string = rModel.getToolTip();
            if (string == null) {
                this.objmgr.setWorking(false);
                return;
            }
            jToolTip.setTipText(rModel.getToolTip());
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this);
            this.objmgr.summary = PopupFactory.getSharedInstance().getPopup(this, jToolTip, point.x + 20, point.y + 25);
            this.objmgr.summary.show();
            this.objmgr.setWorking(false);
        }
    }

    class FilterPanel
    extends JPanel
    implements KeyListener {
        private static final long serialVersionUID = -4159489679875254193L;
        JTextField name = new JTextField();
        JTextField data = new JTextField();
        JTextField type = new JTextField();
        JTextField family = new JTextField();
        JTextField[] filters = new JTextField[]{this.name, this.data, this.type, this.family};
        ModelBrowserTable table;

        public FilterPanel(ModelBrowserTable modelBrowserTable2) {
            FlowLayout flowLayout = new FlowLayout(0);
            flowLayout.setVgap(0);
            flowLayout.setHgap(0);
            this.setLayout(flowLayout);
            this.table = modelBrowserTable2;
            this.add(this.name);
            this.add(this.data);
            this.add(this.type);
            this.add(this.family);
            this.name.addKeyListener(this);
            this.data.addKeyListener(this);
            this.type.addKeyListener(this);
            this.family.addKeyListener(this);
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    FilterPanel.this.resizeFields();
                }
            });
        }

        public void resizeFields() {
            this.name.setPreferredSize(new Dimension(this.table.getColumn(ModelBrowserTable.this.colnames[0]).getWidth(), 25));
            this.data.setPreferredSize(new Dimension(this.table.getColumn(ModelBrowserTable.this.colnames[1]).getWidth(), 25));
            this.type.setPreferredSize(new Dimension(this.table.getColumn(ModelBrowserTable.this.colnames[2]).getWidth(), 25));
            this.family.setPreferredSize(new Dimension(this.table.getColumn(ModelBrowserTable.this.colnames[3]).getWidth(), 25));
        }

        public void setSize(Dimension dimension) {
            this.resizeFields();
            super.setSize(dimension);
        }

        public void setSize(int n, int n2) {
            this.resizeFields();
            super.setSize(n, n2);
        }

        private void filterModels() {
            ModelBrowserTable.this.fmodels.clear();
            Iterator iterator = ModelBrowserTable.this.models.iterator();
            while (iterator.hasNext()) {
                RModel rModel = (RModel)iterator.next();
                if (!this.matches(rModel.getInfo())) continue;
                ModelBrowserTable.this.fmodels.add(rModel);
            }
            this.table.refresh();
        }

        private boolean matches(Vector vector) {
            for (int i = 0; i < this.filters.length; ++i) {
                String string = this.filters[i].getText();
                String string2 = (String)vector.elementAt(i);
                if (string != null && string.trim().length() > 0 && (string2 == null || string2.trim().length() == 0)) {
                    return false;
                }
                if (string == null || string2 == null || this.compareF(string2.trim(), string.trim())) continue;
                return false;
            }
            return true;
        }

        private boolean compareF(String string, String string2) {
            if (string.startsWith(string2)) {
                return true;
            }
            try {
                if (string.matches(string2)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.filterModels();
        }
    }

    class ModelTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1243689917922294377L;

        public void addColumn(TableColumn tableColumn) {
            tableColumn.setCellRenderer(new DefaultTableCellRenderer());
            if (tableColumn.getModelIndex() == 0) {
                tableColumn.setPreferredWidth(100);
            } else if (tableColumn.getModelIndex() == 1) {
                tableColumn.setPreferredWidth(80);
            } else if (tableColumn.getModelIndex() == 2) {
                tableColumn.setPreferredWidth(50);
            } else if (tableColumn.getModelIndex() == 4) {
                tableColumn.setPreferredWidth(40);
            }
            super.addColumn(tableColumn);
        }

        public TableColumn getColumn(int n) {
            return super.getColumn(n < 0 ? 0 : n);
        }
    }

    class ModelTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1098695966813872521L;

        ModelTableModel() {
        }

        public int getColumnCount() {
            return ModelBrowserTable.this.colnames.length;
        }

        public int getRowCount() {
            return ModelBrowserTable.this.fmodels.size();
        }

        public String getColumnName(int n) {
            return ModelBrowserTable.this.colnames[n];
        }

        public Object getValueAt(int n, int n2) {
            return ((RModel)ModelBrowserTable.this.fmodels.elementAt(n)).getInfo().elementAt(n2);
        }

        public Class getColumnClass(int n) {
            int n2 = 0;
            while (((RModel)ModelBrowserTable.this.fmodels.elementAt(n2)).getInfo().elementAt(n) == null) {
                ++n2;
            }
            if (n2 > this.getRowCount()) {
                return null;
            }
            return ((RModel)ModelBrowserTable.this.fmodels.elementAt(n2)).getInfo().elementAt(n).getClass();
        }
    }
}

