\name{create_sentiment_map}
\alias{create_sentiment_map}

\title{
Create Interactive Sentiment Map
}
\description{
This function creates an interactive Leaflet map showing disaster locations colored by sentiment.
}
\usage{
create_sentiment_map(data, lat_col = "Latitude", lon_col = "Longitude")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
A data.frame with sentiment analysis results
}
  \item{lat_col}{
Name of latitude column (default: "Latitude")
}
  \item{lon_col}{
Name of longitude column (default: "Longitude")
}
}

\value{
Leaflet map object
}

\author{
Hossein Hassani and Leila Marvian Mashhad and Nadejda Komendantova.
}

\examples{
sample_data <- data.frame(
  City               = c("CityA", "CityB", "CityC"),
  Longitude          = c(10.0, 11.5, 12.2),
  Latitude           = c(50.1, 49.9, 50.5),
  sentiment_score    = c( 2.5, -1.0,  0.0),
  sentiment_category = c("Positive", "Negative", "Neutral"),
  User_Comment       = c(
    "Amazing rescue efforts!",
    "Terrible flooding last night.",
    "All calm here."
  ),
  stringsAsFactors = FALSE
)

sentiment_map <- create_sentiment_map(sample_data,
                                      lat_col = "Latitude",
                                      lon_col = "Longitude")

sentiment_map
}


