% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcDissim.R
\name{calcCondProb}
\alias{calcCondProb}
\title{Calculate Conditional Probabilities.}
\usage{
calcCondProb(myDataAll)
}
\arguments{
\item{myDataAll}{A data frame which includes qualitative variables OR discretized quantitative variables
OR a mixture of qualitative variables and discretized quantitative variables in columns.}
}
\value{
A data frame with four columns J, A, B and C in columns where Pr(A|B) = C and J is the column number in the input
data frame corresponding to the values in A.
}
\description{
Takes in a data frame which contains only qualitative variables. Discretized quantitative variables
, a mixture of qualitative variables and discretized quantitative variables are also accepted.
Calculates conditional probabilities for each pair of attribute values in  the data frame.
Returns a data frame consists of J, A, B and C in columns where Pr(A|B) = C and J is the column number in the input
data frame corresponding to the values in A.
}
\examples{
QualiVars <- data.frame(Qlvar1 = c("A","B","A","C"), Qlvar2 = c("Q","Q","R","Q"))
CalcForQuali <- calcCondProb(QualiVars)
QuantVars <- data.frame(Qnvar1 = c(1.5,3.2,4.9,5), Qnvar2 = c(4.8,2,1.1,5.8))
Discretized <- discretizeQuant(QuantVars)
CalcForQuant <- calcCondProb(Discretized)
AllQualQuant <- data.frame(QualiVars, Discretized)
CalcForAll <- calcCondProb(AllQualQuant)
}

