% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMO.R
\name{KMO}
\alias{KMO}
\title{Kaiser-Meyer-Olkin criterion}
\source{
Kaiser, H. F. (1970). A second generation little jiffy. Psychometrika,
35, 401-415.

Kaiser, H. F. & Rice, J. (1974). Little jiffy, mark IV. Educational
and Psychological Measurement, 34, 111-117.

Cureton, E. E. & D'Augustino, R. B. (1983). Factor analysis: An
 applied approach. Hillsdale, N.J.: Lawrence Erlbaum Associates, Inc.
}
\usage{
KMO(
  x,
  use = c("pairwise.complete.obs", "all.obs", "complete.obs", "everything",
    "na.or.complete"),
  cor_method = c("pearson", "spearman", "kendall")
)
}
\arguments{
\item{x}{data.frame or matrix. Dataframe or matrix of raw data or matrix with
correlations.}

\item{use}{character. Passed to \code{\link[stats:cor]{stats::cor}} if raw
data is given as input. Default is "pairwise.complete.obs".}

\item{cor_method}{character. Passed to \code{\link[stats:cor]{stats::cor}}.
Default is "pearson".}
}
\value{
A list containing
\item{KMO}{Overall KMO.}
\item{KMO_i}{KMO for each variable.}
\item{settings}{A list of the settings used.}
}
\description{
This function computes the Kaiser-Meyer-Olkin (KMO) criterion overall and for
each variable in a correlation matrix. The KMO represents the degree to
which each observed variable is predicted by the other variables in the
dataset and with this indicates the suitability for factor analysis.
}
\details{
Kaiser (1970) proposed this index, originally called measure of
sampling adequacy (MSA), that indicates how near the inverted correlation
matrix \eqn{R^{-1}} is to a diagonal matrix \eqn{S} to determine a given
correlation matrix's (\eqn{R}) suitability for factor analysis.
The index is
\deqn{KMO = \frac{\sum\limits_{i<j}\sum r_{ij}^2}{\sum\limits_{i<j}\sum r_{ij}^2 + \sum\limits_{i<j}\sum q_{ij}^2}}
with \eqn{Q = SR^{-1}S} and S = \eqn{(diag R^{-1})^{-1/2}} where
\eqn{\sum\limits_{i<j}\sum r_{ij}^2} is the sum of squares of the upper
off-diagonal elements of \eqn{R} and \eqn{\sum\limits_{i<j}\sum q_{ij}^2} is the
sum of squares of the upper off-diagonal elements of \eqn{Q} (see also Cureton & D'Augustino, 1983).

So KMO varies between 0 and 1, with larger values indicating higher suitability
for factor analysis. Kaiser and Rice (1974) suggest that KMO should at least
exceed .50 for a correlation matrix to be suitable for factor analysis.

This function was heavily influenced by the \code{\link[psych:KMO]{psych::KMO}}
function.

See also \code{\link{BARTLETT}} for another test of suitability for factor
analysis.

The \code{KMO} function can also be called together with the
\code{\link{BARTLETT}} function and with factor retention criteria in the
 \code{\link{N_FACTORS}} function.
}
\examples{
KMO(test_models$baseline$cormat)
}
\seealso{
\code{\link{BARTLETT}} for another measure to determine
suitability for factor analysis.

\code{\link{N_FACTORS}} as a wrapper function for this function,
\code{\link{BARTLETT}} and several factor retention criteria.
}
