% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.overlap.R
\name{raster.overlap}
\alias{raster.overlap}
\title{raster.overlap, measures overlap between two ENMs}
\usage{
raster.overlap(x, y, verbose = FALSE)
}
\arguments{
\item{x}{A raster or RasterLayer object, or ENMTools model object containing a suitability raster.}

\item{y}{Another raster or RasterLayer object, or ENMTools model object containing a suitability raster.}

\item{verbose}{Controls printing of diagnostic messages}
}
\value{
results A vector containing the three metrics (I, D, and Spearman rank correlation)
}
\description{
This function measures similarity in the geographic distribution of suitability scores
from two ENMs.  It returns two metrics, I and D.  These metrics are described in
Warren et al. 2008.
}
\examples{
aurelioi.glm <- enmtools.glm(iberolacerta.clade$species$aurelioi,
euro.worldclim, f = pres ~ bio1 + bio12)
aranica.glm <- enmtools.glm(iberolacerta.clade$species$aranica,
euro.worldclim, f = pres ~ bio1 + bio12)
raster.overlap(aurelioi.glm, aranica.glm)
}
\keyword{keywords}
