\name{EQUAL_insert_signature_file}
\alias{EQUAL_insert_signature_file}
\title{
Insert digital signature for a file
}
\description{
"Insert digital signature for a file using the private key generated by
\code{\link[=EQUAL_encrypt_generate_keys]{EQUAL_encrypt_generate_keys()}}
function and \pkg{openssl}. This uses the SHA384 algorithm for the hash
function."
}
\usage{
EQUAL_insert_signature_file(file_name, private_key_folder, key_name)
}
\arguments{
\item{file_name}{Name of the file for which signature must be inserted}
\item{private_key_folder}{Location of the private key}
\item{key_name}{Name of the private key}
}
\value{
signature
}
\references{
\url{https://sites.google.com/view/equal-group/home}
}
\author{
Kurinchi Gurusamy
}
\note{
"This is part of a suite of functions required to allow encrypting and
decrypting whole files and encrypting and decrypting columns of data
programs to run. This is unlikely to be used as a stand alone function."
}
\seealso{
\code{\link[=EQUAL_encrypt_generate_keys]{EQUAL_encrypt_generate_keys()}}
\code{\link[openssl:signature_create]{openssl::signature_create()}}
\code{\link[openssl:hashing]{openssl::hashing()}}
}
\concept{EQUALencrypt}
\examples{
library(openssl)
# Encryption keys ####
test_folder <- tempfile(pattern = "folder_")
public_key_folder <- paste0(test_folder, "/public_key_folder")
private_key_folder <- paste0(test_folder, "/private_key_folder")
dir.create(test_folder)
dir.create(public_key_folder)
dir.create(private_key_folder)
encryption_keys <- EQUAL_encrypt_generate_keys(
  public_key_folder = public_key_folder,
  private_key_folder = private_key_folder,
  key_name = "encryption_key.txt")
# Data ####
data <- lapply(1:3, function(x) {
  mean = sample(1:100, 1, replace = FALSE)
  sd = sample(1:100, 1, replace = FALSE)
  rnorm(100, mean = mean, sd = sd)
})
data <- do.call(cbind.data.frame, data)
colnames(data) <- paste0("v", formatC(1:3, width = 6, flag = "0"))
test_file <- write.csv(data, paste0(tempdir(), "/test.csv"), row.names = FALSE,
na = "")
# Encrypt data ####
encrypted_data <- EQUAL_encrypt_file(file_name = paste0(tempdir(), "/test.csv"),
                                     public_key_folder = public_key_folder,
                                     key_name = "encryption_key.txt")
data_storage_folder <- paste0(test_folder, "/data_storage_folder")
dir.create(data_storage_folder)
saveRDS(encrypted_data, paste0(data_storage_folder, "/encrypted_file.RDS"))
# Insert signature ####
results <- EQUAL_insert_signature_file(file_name = paste0(data_storage_folder,
"/encrypted_file.RDS"), private_key_folder = private_key_folder,
                            key_name = "encryption_key.txt")
}
