% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getNMFgenes}
\alias{getNMFgenes}
\title{Get list of genes for each NMF program}
\usage{
getNMFgenes(
  nmf.res,
  specificity.weight = 5,
  weight.explained = 0.5,
  max.genes = 200
)
}
\arguments{
\item{nmf.res}{A list of NMF models obtained using \code{multiNMF()}}

\item{specificity.weight}{A parameter controlling how specific gene
should be for each program. `specificity.weight=0` no constraint on
specificity, and positive values impose increasing specificity.}

\item{weight.explained}{Fraction of NMF weights explained by selected
genes. For example if weight.explained=0.5, all genes that together
account for 50\% of NMF weights are used to return program signatures.}

\item{max.genes}{Max number of genes for each program}
}
\value{
Returns a list of top genes for each gene program found
    by \code{multiNMF()}
}
\description{
Run it over a list of NMF models obtained using \code{multiNMF()}
}
\examples{
library(Seurat)
data(sampleObj)
geneNMF_programs <- multiNMF(list(sampleObj), k=5)
geneNMF_genes <- getNMFgenes(geneNMF_programs)

}
