\name{muscle.plot.stl}
\alias{muscle.plot.stl}
\title{
Plot and export muscle fibers to stl}
\description{
Plot a series of muscle fibers produced by good.fibes. Fibers are smoothed using splines before plotting. Optionally export an STL file in the correct size scale.}
\usage{
muscle.plot.stl(fiber.list, res = 1, df = 2, radius = 1, cols = NULL,
save.plot = FALSE, file.name = "muscle.fibers.stl", mirror.axis = FALSE)
}
\arguments{
  \item{fiber.list}{
A list of fibers with $fiber points. Generated by good.fibes or processed cleaned by other functions
}
  \item{res}{
The isometric resolution of the original scan (i.e., the distance between images). Provided as a linear measure (um, mm, etc.)
}
  \item{df}{
The degrees of freedom to pass to splines2::nsp for smoothing fiber paths. df = 1 gives a straight path, while >1 gives increasingly curved paths
}
  \item{radius}{
The radius of the lines plotted for muscle fibers
}
  \item{cols}{
An optional vector of colors, the same order and length of fiber.list
}
  \item{save.plot}{
When TRUE, plot is saved as an .stl object in the current working directory. Provide file in file.name argument.
}
  \item{file.name}{
Character data giving the file.name and ending in .stl
}
  \item{mirror.axis}{
Depending on the way the image stack was exported, fibers may be reflected from their original original. mirror.axis = TRUE will reflect the fibers before plotting to correct this
}
}
\value{
Returns a 3D plot
}

\references{
Arbour, J. In Prep. GoodFibes: an R package for the detection of muscle fibers from diceCT scans.
}
\author{
J. Arbour
}
\seealso{
\code{\link{muscle.plot.multi}},\code{\link{muscle.plot}},\code{\link{good.fibes}}
}
\examples{

data(ant.final)
\donttest{
muscle.plot.stl(ant.final, res = 0.000673107, df=1, radius = 1, 
mirror.axis = TRUE, save.plot = FALSE)
}
}
