% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haplotype_variants_global.R
\name{haplotype_variants_global}
\alias{haplotype_variants_global}
\title{Identify Haplotype Variants Globally}
\usage{
haplotype_variants_global(
  vcf_list,
  LD_list,
  epsilon = NULL,
  MGmin = 30,
  minFreq = 2,
  hetmiss_as = "allele",
  keep_outliers = FALSE,
  format = 1
)
}
\arguments{
\item{vcf_list}{A list of VCF files.}

\item{LD_list}{A list of LD matrix files.}

\item{epsilon}{A list of epsilon values the same length as the list of VCF files. The epsilon affects haplotype size. It is a parameter of the DBSCAN clustering tool. The default is 0.6.}

\item{MGmin}{The minimum number of SNPs within a cluster for it to be defined as a haplotype.The default is 30.}

\item{minFreq}{The minimum number of individuals a haplotype variant must be present in to be considered a valid haplotype variant. The default is 2.}

\item{hetmiss_as}{Affects how missing data is handled for all instances where one allele in a genotype is missing.If hetmiss_as = "allele" the genotype is assumed to be heterozygous. If hetmiss_as = "miss" the genotype is treated as NA.}

\item{keep_outliers}{If FALSE removes SNPs, that are determined to be outliers.}

\item{format}{The output format. There are six different output formats (1,2,3,4,5,6).}
}
\value{
A table of haplotype genotypes in your chosen format.
}
\description{
This function requires a list of VCF files and an LD matrices.
It will then define local haplotypes and identify the variants for each haplotype.
The output can be formatted in six ways, to be compatible with a wide range of GWAS and genomic selection tools.
}
