% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_vector_filter.R
\name{shiny_vector_filter}
\alias{shiny_vector_filter}
\title{Vector-specific filter module server function}
\usage{
shiny_vector_filter(data, inputId, global = FALSE)
}
\arguments{
\item{data}{the data object to be filtered}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{global}{The \code{logical} TODO}
}
\value{
a shiny server function as described in the details
}
\description{
The \code{shiny_vector_filter} family of S3 dispatched functions use the
input data to route to the appropriate ui and server functions for the vector
datatype.
}
\details{
The \code{shiny_vector_filter} functions return the shiny module server
functions to use for the specified filter. These functions should follow the
following template:

\preformatted{
  function(input, output, session, x, filter_na, verbose = FALSE) {
    # ... additional code here
    reactiveValues(code = TRUE, mask = TRUE)
  }
}

This function will conform to the following specification

\strong{Arguments}
\describe{
\item{\code{input}}{
  requisite shiny module field specifying incoming ui input reactiveValues
}
\item{\code{output}}{
  requisite shiny module field capturing output for the shiny data filter 
  ui
}
\item{\code{session}}{
  requisite shiny module field containing the active shiny session
}
\item{\code{x}}{
  a reactive expression resolving to the vector to filter
}
\item{\code{filter_na}}{
  a logical value indicating whether to filter \code{NA} values from the
  \code{x} vector
}
\item{\code{verbose}}{
  a \code{logical} value indicating whether or not to print log
  statements out to the console
}
}

\strong{Value}
a \code{\link[shiny]{reactiveValues}} list containing a logical vector
called "mask" which can be used to filter the provided vector and an element
"code" which is the expression used to generate the mask.
}
\keyword{internal}
