% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropplot.R
\name{dropplot}
\alias{dropplot}
\title{Dropout Curve and Observation Distribution for Irregular Longitudinal Data}
\usage{
dropplot(data, id_col, time_col, bins = 100, percentile = 90)
}
\arguments{
\item{data}{A data frame containing the longitudinal data.}

\item{id_col}{A character string specifying the column name for subject identifiers.}

\item{time_col}{A character string specifying the column name for the time variable.}

\item{bins}{Number of bins for the histogram (default is 100).}

\item{percentile}{A numeric value between 0 and 100 specifying the cutoff for the red dropout line (default is 90).}
}
\value{
A list with two elements:
\itemize{
  \item \code{plot}: A ggplot object showing the dropout curve and histogram.
  \item \code{data}: A data frame with mid-points of the time bins (`mid_time`) and the number of observations (`count`) in descending order.
}
}
\description{
This function generates a combined plot of a dropout curve and a histogram of observation counts over time.
The dropout curve shows how many subjects remain in the study over time based on their last observation time.
The histogram shows how the observations are distributed across time.
}
\examples{
\dontrun{
  data(smocc)  # assumes smocc is loaded with columns id and age
  result <- dropplot(data = smocc, id_col = "id", time_col = "age", bins = 60, percentile = 90)
  print(result$plot)
  head(result$data)
}

}
