% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JATS_get.subject.R
\name{get.subject}
\alias{get.subject}
\title{get.subject}
\usage{
get.subject(x, letter.convert = TRUE, paste = "")
}
\arguments{
\item{x}{a NISO-JATS coded XML file or text.}

\item{letter.convert}{Logical. If TRUE converts hexadecimal and HTML coded characters to Unicode.}

\item{paste}{if paste!="" subject list is collapsed to one cell with seperator specified (e.g. paste=";").}
}
\value{
Character vector with extracted subject/s.
}
\description{
Extracts subject tag/s from NISO-JATS coded XML file or text as vector of subjects.
}
\examples{
x<-"Some text <subject>Some subject</subject> some text"
get.subject(x)
x<-"Some text <subject>Some subject</subject> TEXT ...
<subject>Some other subject</subject> Some text "
get.subject(x)
get.subject(x,paste=", ")
}
\seealso{
\code{\link[JATSdecoder]{JATSdecoder}} for simultaneous extraction of meta-tags, abstract, sectioned text and reference list.
}
