% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkRange.R
\name{checkRange}
\alias{checkRange}
\title{Check that the intended irradiances are acheivable by the lights}
\usage{
checkRange(
  intended_irradiance,
  calibration_leds,
  calibration_wavelengths,
  calibration_intensities,
  calibration_irradiances
)
}
\arguments{
\item{intended_irradiance}{Matrix of intended irradiances to be checked. Each row corresponds to an LED channel.}

\item{calibration_leds}{A numeric vector of LED values from calibration, mapping to intensities and irradiances (i.e. the same length)}

\item{calibration_wavelengths}{A numeric vector of wavelengths from calibration, corresponding to intensities and irradiances}

\item{calibration_intensities}{A numeric vector of intensities (heliospectra units) from calibration}

\item{calibration_irradiances}{A numeric vector of measured irradiances (any units, as long as it is consistently used) from calibration}
}
\value{
Boolean: TRUE = pass, FALSE = fail
}
\description{
Check that the intended irradiances are acheivable by the lights
}
\examples{
calib <- LightFitR::calibration
irradiances <- LightFitR::target_irradiance
checkRange(irradiances, calib$led, calib$wavelength, calib$intensity, calib$irradiance)

}
