% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-scores.R
\name{PLR.scores}
\alias{PLR.scores}
\title{Computes Gini scores for the Penalized Lorenz Regression}
\usage{
PLR.scores(y, x, weights, theta.list)
}
\arguments{
\item{y}{the vector of responses}

\item{x}{the design matrix (after data management steps, i.e. standardization and transformations of the categorical covariates into binaries)}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}

\item{theta.list}{list of matrices. Each element of the list correspond to a value of the grid parameter. The columns of the matrices correspond to values of the penalty parameters. The rows correspond to the different covariates.}
}
\value{
A list of vectors gathering the Gini scores. Each element of the list corresponds to a value of the grid parameter and each element of the vector corresponds to a value of the penalization parameter.
}
\description{
\code{PLR.scores} computes the Gini scores (either OOB-scores or CV-scores) obtained for a specific validation sample and associated to a list of parameters obtained by the Penalized Lorenz Regression.
}
\keyword{internal}
