test_that("single-variant GEI and Joint test meta-analysis", {
  infile1 <- system.file("extdata", "meta1.txt", package = "MAGEE")
  infile2 <- system.file("extdata", "meta2.txt", package = "MAGEE")
  infile3 <- system.file("extdata", "meta3.txt", package = "MAGEE")
  infile4 <- system.file("extdata", "meta4.txt", package = "MAGEE")
  infile5 <- system.file("extdata", "meta5.txt", package = "MAGEE")
  outfile <- tempfile()
  glmm.gei.meta(files = c(infile1, infile2, infile3, infile4, infile5), outfile = outfile, interaction="sex")
  out <- read.table(outfile, header = TRUE, as.is = TRUE)
  outPval<-c(7.398859e-01, 1.057351e-03, 4.710037e-01, 9.201342e-01, 6.607810e-01,7.933586e-02, 4.072482e-01, 1.997179e-01, 8.607651e-01, 2.508775e-03,9.637767e-01, 2.540691e-01, 9.556030e-01, 6.061708e-01, 6.718866e-01,8.917068e-01, 5.476881e-01, 6.643518e-01, 4.905400e-01, 9.769166e-01,2.244303e-01, 9.112266e-02, 3.718101e-05, 8.142838e-01, 3.259739e-01,4.175679e-01, 5.000037e-01, 3.301131e-01, 6.235216e-01, 8.682540e-01,2.557019e-01, 1.277121e-01, 7.233825e-06, 3.025667e-01, 6.202095e-01,4.754977e-01, 9.279986e-02, 9.792363e-01)
  outPInter <-c(0.5790208, 0.1093653, 0.3767503, 0.8823533, 0.7874718, 0.7479180, 0.1487494,0.6676540, 0.9418788, 0.9535481, 0.9051734, 0.9088930, 0.6371354, 0.5417539, 0.9234620, 0.8480848, 0.8252201, 0.2630100, 0.5381997, 0.4039424, 0.2933382, 0.8282541, 0.3898889, 0.5051126, 0.4963767, 0.3966174, 0.1814198, 0.8571967, 0.2189795, 0.9505792, 0.8922224, 0.2276500, 0.8838127, 0.9986869, 0.7889524, 0.9907661, 0.2240231, 0.6763448)
  outPjoint <- c( 0.949407885, 1.000000000, 0.665978825, 0.573433101, 0.923653779, 0.945449141, 0.302236496, 0.791138961, 0.866489502, 0.244480824, 0.137567194, 1.000000000,0.897320339, 0.524476927, 1.000000000, 0.974526780, 1.000000000, 0.376288280,0.752089521, 0.478385561, 0.352040017, 0.001349215, 0.679732740, 0.659722563, 1.000000000, 0.683100198, 0.853462983, 0.951621468, 0.352909404, 0.053420453,0.592855004, 0.464863052, 0.519505489, 0.997982790, 1.000000000, 0.933210493,0.444521097, 1.000000000)
  expect_equal(signif(out$P_Value_Marginal, 5), signif(outPval, 5))
  expect_equal(signif(out$P_Value_Joint, 5), signif(outPjoint, 5))
  expect_equal(signif(out$P_Value_Interaction, 5), signif(outPInter, 5))
  unlink(outfile)
})

