% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume_form_factors.R
\name{volume_form_factors}
\alias{volume_form_factors}
\title{volume_form_factors}
\usage{
volume_form_factors(
  df,
  form_factors = NULL,
  form_factors_level = "species",
  uniform_form_factor = 0.42
)
}
\arguments{
\item{df}{data frame with tree heights and basal areas for individual trees}

\item{form_factors}{data frame with for factors for species, plot or both}

\item{form_factors_level}{character, the level of specified form factors. It
can be 'species', 'plot' or 'species_plot'}

\item{uniform_form_factor}{a uniform form factor to be applied to all trees.
If specified, it overwrites the argument 'form_factors'}
}
\value{
a data frame with calculated volume for all trees
}
\description{
The calculation of individual tree volume using form factors, which can be
defined per species, per plot, or per species and per plot
}
\examples{
library(MLFS)
data(data_v3)
data(form_factors)

data_v3 <- volume_form_factors(df = data_v3, form_factors = form_factors,
  form_factors_level = "species_plot")

summary(data_v3)

}
