% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread_stats.R
\name{spread_stats}
\alias{spread_stats}
\title{Summary of Spread Statistics}
\usage{
spread_stats(x)
}
\arguments{
\item{x}{A numeric vector}
}
\value{
\describe{
\item{sd}{Standard Deviation}
\item{iqr}{Inter Quartile Range}
\item{minz}{Normalized Minimum}
\item{maxz}{Normalized Maximum}
\item{diffz}{Normalized Range}
\item{pct1}{Percent of data within 1 standard deviation from \code{pct()}}
\item{pct2}{Percent of data within 2 standard deviation from \code{pct()}}
\item{pct3}{Percent of data within 3 standard deviation from \code{pct()}}
}
}
\description{
Computes a variety of spread statistics for a numeric vector, including:
standard deviation, iqr, the normalized minimum, maximum,
and range as well as the percentage of data within 1, 2,
and 3 standard deviations (via \code{pct()})
}
\examples{
# Spread stats of random normal data
set.seed(123)
x <- rnorm(1000)
spread_stats(x)

# Spread stats of mpg in mtcars
data("mtcars")
spread_stats(mtcars$mpg)

}
\seealso{
\code{\link{pct}}
}
