% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{em_stable_mixture}
\alias{em_stable_mixture}
\title{EM algorithm for alpha-stable mixture using a custom estimator}
\usage{
em_stable_mixture(data, u, estimator_func, max_iter = 300, epsilon = 0.001)
}
\arguments{
\item{data}{Numeric vector of observations.}

\item{u}{Numeric vector of frequency values for ECF.}

\item{estimator_func}{Function to estimate stable parameters.}

\item{max_iter}{Integer. Maximum number of EM iterations.}

\item{epsilon}{Numeric. Convergence threshold on log-likelihood.}
}
\value{
List with estimated weights, parameters, and log-likelihood.
}
\description{
Performs EM estimation using a user-defined parameter estimator and ECF frequencies.
}
