# Clean environment and load libraries
rm(list = ls())  # Clear environment to avoid conflicts

# Source filess
library(MixStable)


# Set seed and generate synthetic data
set.seed(0)
S <- rnorm(77)
u <- seq(min(S), max(S), length.out = 100)

# Fit the model using the custom EM algorithm
result <- em_stable_mixture(S, u, estimator_func = estimate_stable_weighted_ols)

# Print results
cat("Estimated Weights:", result$weights, "\n")
cat("Cluster 1 Params:", paste(result$params1, collapse = ", "), "\n")
cat("Cluster 2 Params:", paste(result$params2, collapse = ", "), "\n")
cat("Log-Likelihood:", result$log_likelihood, "\n")

# Plot the final mixture fit
plot_final_mixture_fit(S, result$params1, result$params2, result$weights)
