% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restoreShapes.r
\name{getPCscores}
\alias{getPCscores}
\title{Obtain PC-scores for new landmark data}
\usage{
getPCscores(x, PC, mshape)
}
\arguments{
\item{x}{landmarks aligned (e.g. using \code{\link{align2procSym}} to the meanshape of data the PCs are derived from.}

\item{PC}{Principal components (eigenvectors of the covariance matrix)}

\item{mshape}{matrix containing the meanshape's landmarks (used to center the data)}
}
\value{
returns a matrix containing the PC scores
}
\description{
Obtain PC-scores for new landmark data
}
\examples{
\dontrun{
data(boneData)
proc <- procSym(boneLM[,,-c(1:2)])
newdata <- boneLM[,,c(1:2)]
newdataAlign <- align2procSym(proc,newdata)
scores <- getPCscores(newdataAlign,proc$PCs,proc$mshape)
}
}
\seealso{
\code{\link{restoreShapes}}
}
