% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsOnOutline.r
\name{resampleCurve}
\alias{resampleCurve}
\title{Resample a curve equidistantly}
\usage{
resampleCurve(x, n, smooth = FALSE, smoothn = n, open = TRUE)
}
\arguments{
\item{x}{matrix containing coordinates}

\item{n}{number of resulting points on the resampled curve}

\item{smooth}{logical: if TRUE, the resulting curve will be smoothed by using bezier curves.}

\item{smoothn}{integer: define the refinement of the bezier curve. The higher this value, the closer the final curve will be to the original.}

\item{open}{logical: define whether it is a closed curve or not.}
}
\value{
returns a matrix containing the resampled curve
}
\description{
Resample a curve equidistantly (optionally with smoothing)
}
\examples{
data(nose)
x <- shortnose.lm[c(304:323),]
xsample <- resampleCurve(x,n=50)
}
