% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ss_matrix.R
\name{get_ss_matrix}
\alias{get_ss_matrix}
\title{Sample size matrix for a platform trial with a given number of treatment arms}
\usage{
get_ss_matrix(num_arms, n_arm, d)
}
\arguments{
\item{num_arms}{Integer. Number of experimental treatment arms in the trial.}

\item{n_arm}{Integer. Sample size per experimental treatment arm.}

\item{d}{Integer vector with timings of adding new arms in terms of number of patients recruited to the trial so far. The first entry must be 0, so that the trial starts with at least one experimental treatment arm, and the entries must be non-decreasing. The vector length equals \code{num_arms}.}
}
\value{
Sample size matrix, consisting of the sample size per arm and per period, where the arms are represented in the rows (with the control arm in the first row and the experimental arms coming after ordered by entry time) and the periods are represented in the columns.
}
\description{
This function computes the matrix with sample sizes per arm and period. It is used in the functions \code{datasim_bin()} and \code{datasim_cont()}.
}
\examples{

get_ss_matrix(num_arms = 3, n_arm = 100, d = c(0, 100, 250))

}
\author{
Pavla Krotka
}
