% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trial.R
\name{plot_trial}
\alias{plot_trial}
\title{Function for visualizing the simulated trial}
\usage{
plot_trial(treatments)
}
\arguments{
\item{treatments}{Vector with indices of assigned arms for each participant, ordered by time, e.g. column \code{treatment} from the dataframe resulting from the \code{datasim_bin()} or \code{datasim_cont()} function.}
}
\value{
ggplot showing trial progress over time.
}
\description{
This function creates a plot visualizing the trial progress over time.
}
\examples{

trial_data <- datasim_bin(num_arms = 3, n_arm = 100, d = c(0, 100, 250),
p0 = 0.7, OR = rep(1.8, 3), lambda = rep(0.15, 4), trend="stepwise")

plot_trial(treatments = trial_data$treatment)


}
\author{
Pavla Krotka
}
