% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepmodel_cont.R
\name{sepmodel_cont}
\alias{sepmodel_cont}
\title{Separate analysis for continuous data}
\usage{
sepmodel_cont(data, arm, alpha = 0.025, check = TRUE, ...)
}
\arguments{
\item{data}{Data frame trial data, e.g. result from the \code{datasim_cont()} function. Must contain columns named 'treatment', 'response' and 'period'.}

\item{arm}{Integer. Index of the treatment arm under study to perform inference on (vector of length 1). This arm is compared to the control group.}

\item{alpha}{Double. Significance level (one-sided). Default=0.025.}

\item{check}{Logical. Indicates whether the input parameters should be checked by the function. Default=TRUE, unless the function is called by a simulation function, where the default is FALSE.}

\item{...}{Further arguments passed by wrapper functions when running simulations.}
}
\value{
List containing the following elements regarding the results of comparing \code{arm} to control:
\itemize{
\item \code{p-val} - p-value (one-sided)
\item \code{treat_effect} - estimated treatment effect in terms of the difference in means
\item \code{lower_ci} - lower limit of the (1-2*\code{alpha})*100\% confidence interval
\item \code{upper_ci} - upper limit of the (1-2*\code{alpha})*100\% confidence interval
\item \code{reject_h0} - indicator of whether the null hypothesis was rejected or not (\code{p_val} < \code{alpha})
\item \code{model} - fitted model
}
}
\description{
This function performs separate analysis (only taking into account concurrent controls) using a linear model.
}
\details{
The separate analysis takes into account only the data from the evaluated experimental treatment arm and its concurrent controls and uses a linear regression model to evaluate the given treatment arm.
Denoting by \eqn{y_j} the continuous response for patient \eqn{j}, by \eqn{k_j} the arm patient \eqn{j} was allocated to, and by \eqn{M} the treatment arm under evaluation, the regression model is given by:

\deqn{E(y_j) = \eta_0  + \theta_M \cdot I(k_j=M)}

where \eqn{\eta_0} is the response in the concurrent controls;
\eqn{\theta_M} represents the treatment effect of treatment \eqn{M} as compared to control.
}
\examples{

trial_data <- datasim_cont(num_arms = 3, n_arm = 100, d = c(0, 100, 250),
theta = rep(0.25, 3), lambda = rep(0.15, 4), sigma = 1, trend = "linear")

sepmodel_cont(data = trial_data, arm = 3)

}
\author{
Pavla Krotka
}
