% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.r
\name{aggr_data}
\alias{aggr_data}
\title{convert individual event information to aggregated information per network node}
\usage{
aggr_data(dat, from = NULL, cumsum = TRUE)
}
\arguments{
\item{dat}{\code{data.frame} with variables \code{'node'}, \code{'time'}, \code{'delay'}, events data with single events with count magnitude}

\item{from}{character in \code{\link{strftime}} format, e.g. \code{"2014-06-12 16:15"}, data is subsetted accordingly before aggregation}

\item{cumsum}{logical indicating whether data is aggregated by cumulative sum, default is \code{TRUE}}
}
\value{
\code{data.frame} of dimension \code{(TxK)}, where \code{T} is the number of observation times and \code{K} the number of network nodes. Thus, each row represents a snapshot of the spreading process at a specific observation time with the event magnitude observed at the network nodes. Rownames are observation times, colnames are node names.
}
\description{
convert individual event information to aggregated information per network node
}
\seealso{
Other data_handling: 
\code{\link{read_DB_data}()}
}
\concept{data_handling}
