% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{installStudy}
\alias{installStudy}
\title{Install a study as an R package}
\usage{
installStudy(study, requireValid = TRUE, library = .libPaths()[1])
}
\arguments{
\item{study}{An OmicNavigator study to install (class \code{onStudy})}

\item{requireValid}{Require that study is valid before installing (passed to
\code{\link{exportStudy}}, which runs \code{\link{validateStudy}})}

\item{library}{Directory to install package. Defaults to first directory
returned by \code{\link{.libPaths}}.}
}
\value{
Invisibly returns the original \code{onStudy} object that was passed
to the argument \code{study}
}
\description{
Install a study as an R package
}
\details{
Note that \code{installStudy} is only intended for directly
installing an OmicNavigator study object loaded in your current R session.
If you have already exported your study to a package tarball via
\code{\link{exportStudy}}, then you can install it with
\code{\link[utils]{install.packages}}, for example:

\preformatted{
  tarball <- exportStudy(myStudy)
  install.packages(tarball, repos = NULL)
  }
}
