% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_selector.R
\name{get_equipment_by_ids}
\alias{get_equipment_by_ids}
\title{Equipment by ID}
\usage{
get_equipment_by_ids(id)
}
\arguments{
\item{id}{Integer or integer vector, containing one or many equipment ids.}
}
\value{
A data.frame of the requested equipment, or an empty list if no equipment matches those ids.
}
\description{
Queries equipment by their ids.
}
\examples{
\dontrun{
equipment <- get_equipment_by_ids(c(1000,1001))

# If you are using the point selector function:
query <- PointSelector()

query$buildings <- 101
query$equipment_types <- 'ahu'

selection <- select_points(query)

equipment <- get_equipment_by_ids(selection$equipment)
}

}
