% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeListCladePartitions}
\alias{PCMTreeListCladePartitions}
\title{A list of all possible clade partitions of a tree with a number of splitting nodes}
\usage{
PCMTreeListCladePartitions(
  tree,
  nNodes,
  minCladeSize = 0,
  skipNodes = character(0),
  tableAncestors = NULL,
  countOnly = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{tree}{a phylo object}

\item{nNodes}{an integer giving the number of partitioning nodes. There would be
\code{nNodes+1} blocks in each partition (see details).}

\item{minCladeSize}{integer indicating the minimum number of tips allowed in a clade.}

\item{skipNodes}{an integer or character vector indicating the ids or labels
of nodes that should not be used as partition nodes. By default, this is an
empty character vector.}

\item{tableAncestors}{NULL (default) or an integer matrix returned by a previous call
to \code{PCMTreeTableAncestors(tree)}.}

\item{countOnly}{logical indicating if the only the number of partitions should
be returned.}

\item{verbose}{a logical indicating if informative messages should be printed to
the console.}
}
\value{
a list of integer \code{nNodes}-vectors. By default a full traversal
of all partitions is done. It is possible to truncate the search to a limited
number of partitions by setting the option PCMBase.MaxLengthListCladePartitions
to a finite positive integer.
}
\description{
Each subset of \code{nNodes} distinct internal or tip nodes
defines a partition of the branches of the tree into \code{nNodes+1} blocks
called parts. This function generates partitions where each part has
\code{nNodes} splitting nodes and contains at least \code{minCladeSize} tips.
}
\seealso{
\code{\link{PCMOptions}}
}
