% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_PERSUADE}
\alias{f_PERSUADE}
\title{Main PERSUADE Function}
\usage{
f_PERSUADE(
  name = "no_name",
  years,
  status,
  group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  cure_link = "logistic",
  time_unit,
  time_horizon,
  time_pred_surv_table
)
}
\arguments{
\item{name}{Character. Name identifier for the analysis (default: "no_name").}

\item{years}{Numeric vector of time-to-event data.}

\item{status}{Numeric vector indicating event occurrence (1 = event, 0 = censoring).}

\item{group}{Factor indicating group membership.}

\item{strata}{Logical. Whether to stratify models by group.}

\item{spline_mod}{Logical. Whether spline models should be fitted.}

\item{cure_mod}{Logical. Whether cure models should be fitted.}

\item{cure_link}{Character string specifying the link function for cure models
("logistic", "loglog", "identity", "probit"; default = "logistic").}

\item{time_unit}{Numeric. The unit of time for annualization.}

\item{time_horizon}{Numeric. The maximum prediction time horizon.}

\item{time_pred_surv_table}{Numeric vector of time points for survival table predictions.}
}
\value{
A list of class \code{"PERSUADE"} containing:
\itemize{
\item \code{input}: Input arguments used in the analysis.
\item \code{surv_obs}: Observed survival results (Kaplan-Meier, hazards, Cox model).
\item \code{surv_model}: Fitted parametric/spline/cure models.
\item \code{surv_pred}: Model predictions.
\item \code{surv_model_excel}: Excel-ready parameter table.
\item \code{misc}: Auxiliary results (labels, number of groups, etc.).
}
}
\description{
Executes the PERSUADE workflow for parametric survival analysis, including Kaplan-Meier,
parametric, spline, and cure models. Produces outputs for visualization, prediction,
and Excel export.
}
\details{
The workflow proceeds in three main stages:
\enumerate{
\item Observed data (Kaplan-Meier, hazards, Cox regression).
\item Parametric, spline, and cure model fitting.
\item Prediction and export of results.
}
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
}
}
\seealso{
\code{\link[=f_hazard]{f_hazard()}}, \code{\link[=f_cum_hazard]{f_cum_hazard()}}, \code{\link[=f_surv_model]{f_surv_model()}}
}
