% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppf_avg_imp.R
\name{ppf_avg_imp}
\alias{ppf_avg_imp}
\title{Global importance measure for a PPforest object as the average IMP PPtree measure over all the trees 
in the forest}
\usage{
ppf_avg_imp(ppf, y)
}
\arguments{
\item{ppf}{is a PPforest object}

\item{y}{A character with the name of the class variable.}
}
\value{
Data frame with the global importance measure
}
\description{
Global importance measure for a PPforest object as the average IMP PPtree measure over all the trees 
in the forest
}
\examples{
#crab data set with all the observations used as training

pprf.crab <- PPforest(data = crab, std = 'min-max', y = 'Type',
 size.tr = 1, m = 100, size.p = .5, PPmethod = 'LDA')
 ppf_avg_imp(pprf.crab, 'Type') 
 
}
\references{
da Silva, N., Cook, D., & Lee, E. K. (2021). A projection pursuit forest 
algorithm for supervised classification. Journal of Computational and Graphical Statistics,
30(4), 1168-1180.
}
